<?php
// src/bootstrap.php - load .env and initialize Database, TelegramClient, MatchService
require_once __DIR__ . '/Database.php';
require_once __DIR__ . '/TelegramClient.php';
require_once __DIR__ . '/MatchService.php';

// simple env loader (same as before)
function load_env($file){
    $env = [];
    if(!file_exists($file)) return $env;
    $lines = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach($lines as $line){
        $line = trim($line);
        if($line === '' || strpos($line,'#')===0) continue;
        if(strpos($line,'=')===false) continue;
        list($k,$v) = explode('=', $line, 2);
        $env[trim($k)] = trim(trim($v), "'\"");
    }
    return $env;
}

$env = load_env(dirname(__DIR__) . '/.env');
// minimal validation
if(empty($env['TELEGRAM_TOKEN'])){
    // allow but warn
    // throw new Exception('TELEGRAM_TOKEN not set in .env');
}

// init objects
$db = new Database($env);
$tg = new TelegramClient($env['TELEGRAM_TOKEN'] ?? '', $env['TELEGRAM_API'] ?? 'https://api.telegram.org', $env['TELEGRAM_PROXY_ENABLED'] ?? false, $env['TELEGRAM_PROXY_URL'] ?? null);
$match = new MatchService($db, $tg);
