<?php
// src/MatchService.php - simple matching logic using database queue
class MatchService {
    private $db;
    private $tg;
    public function __construct($db, $tg){
        $this->db = $db;
        $this->tg = $tg;
    }
    // add user to queue
    public function enqueue($chat_id, $gender=null, $looking_for=null){\n            // check banned\n            $b = $this->db->fetchOne('SELECT * FROM banned WHERE chat_id = ?', [$chat_id]);\n            if($b) return;
        $sql = "INSERT INTO queue (chat_id, gender, looking_for, created_at) VALUES (?, ?, ?, ?)";
        $this->db->exec($sql, [$chat_id, $gender, $looking_for, time()]);
    }
    // try to find a match and pair two users
    public function tryMatch($chat_id){
        // get requester info
        $u = $this->db->fetchOne('SELECT * FROM users WHERE chat_id = ?', [$chat_id]);
        if(!$u) return false;
        // find someone in queue compatible (simple logic: any for now)
        $row = $this->db->fetchOne('SELECT * FROM queue WHERE chat_id != ? LIMIT 1', [$chat_id]);
        if(!$row) return false;
        // pair them
        $partner = $row['chat_id'];
        $this->db->exec('DELETE FROM queue WHERE chat_id = ?', [$partner]);
        $this->db->exec('UPDATE users SET partner = ? WHERE chat_id = ?', [$partner, $chat_id]);
        $this->db->exec('UPDATE users SET partner = ? WHERE chat_id = ?', [$chat_id, $partner]);
        // notify both
        $this->tg->sendMessage($chat_id, 'یافت شد! شروع به صحبت کنید ✅');
        $this->tg->sendMessage($partner, 'یافت شد! شروع به صحبت کنید ✅');
        return true;
    }
    public function leave($chat_id){
        $u = $this->db->fetchOne('SELECT partner FROM users WHERE chat_id = ?', [$chat_id]);
        if(!$u || empty($u['partner'])) return;
        $p = $u['partner'];
        $this->db->exec('UPDATE users SET partner = NULL WHERE chat_id = ?', [$p]);
        $this->db->exec('UPDATE users SET partner = NULL WHERE chat_id = ?', [$chat_id]);
        $this->tg->sendMessage($p, 'طرف مقابل چت را ترک کرد ❌');
        $this->tg->sendMessage($chat_id, 'شما چت را ترک کردید.');
    }
}
