<?php
// src/Database.php - PDO wrapper with prepared statements
class Database {
    private $pdo;
    public function __construct($config){
        $dsn = sprintf('mysql:host=%s;dbname=%s;charset=utf8mb4', $config['DB_HOST'], $config['DB_NAME']);
        $opts = [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
        ];
        $this->pdo = new PDO($dsn, $config['DB_USER'], $config['DB_PASS'], $opts);
    }
    public function pdo(){ return $this->pdo; }
    public function fetch($sql, $params=[]){
        $stmt = $this->pdo->prepare($sql);
        $stmt->execute($params);
        return $stmt->fetchAll();
    }
    public function fetchOne($sql, $params=[]){
        $stmt = $this->pdo->prepare($sql);
        $stmt->execute($params);
        return $stmt->fetch();
    }
    public function exec($sql, $params=[]){
        $stmt = $this->pdo->prepare($sql);
        $stmt->execute($params);
        return $stmt->rowCount();
    }
    public function lastInsertId(){ return $this->pdo->lastInsertId(); }
}
