<?php
// src/Controllers/BotController.php - separates webhook handling logic
class BotController {
    private $db;
    private $tg;
    private $match;
    public function __construct($db, $tg, $match){
        $this->db = $db;
        $this->tg = $tg;
        $this->match = $match;
    }
    public function handle($update){
        // handle message updates and callback_query minimally
        $message = $update['message'] ?? null;
        $callback = $update['callback_query'] ?? null;
        if($callback){
            $this->handleCallback($callback);
            return;
        }
        if(!$message) return;
        $chat_id = $message['chat']['id'];
        $text = $message['text'] ?? '';

        // ensure user row exists using prepared statement via Database
        $u = $this->db->fetchOne('SELECT * FROM users WHERE chat_id = ?', [$chat_id]);
        if(!$u){
            $this->db->exec('INSERT INTO users (chat_id, step, created_at) VALUES (?, ?, ?)', [$chat_id, 'idle', time()]);
            $u = $this->db->fetchOne('SELECT * FROM users WHERE chat_id = ?', [$chat_id]);
        }

        // simple routing of commands
        $cmd = mb_strtolower(trim($text));
        if($cmd === '/start'){
            $this->tg->sendMessage($chat_id, 'سلام! خوش آمدی. برای شروع "▶️ شروع چت" را ارسال کن.');
            return;
        }
        if($cmd === '▶️ شروع چت' || $cmd === 'شروع'){
            $this->match->enqueue($chat_id, $u['gender'] ?? null, $u['looking_for'] ?? null);
            $matched = $this->match->tryMatch($chat_id);
            if(!$matched){
                $this->tg->sendMessage($chat_id, 'در حال جستجو برای شریک... جهت خروج /leave');
            }
            return;
        }
        if($cmd === '/leave' || $cmd === '⛔ پایان چت'){
            $this->match->leave($chat_id);
            return;
        }

        // if chatting, forward text to partner (resend)
        if(!empty($u['partner'])){
            $partner = $u['partner'];
            if(!empty($text)){
                $this->tg->sendMessage($partner, $text);
            } else {
                // for media - instruct to use text for now
                $this->tg->sendMessage($chat_id, 'ارسال رسانه فعلاً در حال بهبود است. لطفاً متن بفرستید.');
            }
            return;
        }

        // fallback help
        $this->tg->sendMessage($chat_id, 'دستور نامشخص. از /start استفاده کنید.');
    }
    private function handleCallback($callback){
        // placeholder for callback_query handling
        $chat_id = $callback['from']['id'];
        $data = $callback['data'] ?? '';
        $this->tg->sendMessage($chat_id, 'Callback received: '.$data);
    }
}
