<?php
session_start();
require_once __DIR__ . '/../src/bootstrap.php';
// simple auth
$env = [];
$env_file = dirname(__DIR__) . '/.env';
if(file_exists($env_file)){
    $lines = file($env_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach($lines as $line){
        $line = trim($line);
        if($line === '' || strpos($line,'#')===0) continue;
        if(strpos($line,'=')===false) continue;
        list($k,$v) = explode('=', $line, 2);
        $env[trim($k)] = trim(trim($v), "'\"");
    }
}
$admin_user = $env['ADMIN_USER'] ?? 'admin';
$admin_pass = $env['ADMIN_PASS'] ?? 'change-me';
if(empty($_SESSION['admin'])){
    if($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['user']) && isset($_POST['pass'])){
        if($_POST['user'] === $admin_user && $_POST['pass'] === $admin_pass){
            $_SESSION['admin'] = true; header('Location: users.php'); exit;
        } else { $msg = 'نام‌کاربری یا رمز اشتباه است'; }
    } else {
        // show login form
        ?>
        <!doctype html><html lang="fa" dir="rtl"><head><meta charset="utf-8"><title>ورود ادمین</title></head><body>
        <h3>ورود مدیر</h3>
        <?php if(!empty($msg)) echo '<p style="color:red">'.htmlspecialchars($msg).'</p>'; ?>
        <form method="post"><label>کاربر: <input name="user"></label><br><label>رمز: <input name="pass" type="password"></label><br><button>ورود</button></form>
        </body></html><?php
        exit;
    }
}
// actions: ban/unban
if(isset($_GET['ban'])){
    $target = intval($_GET['ban']);
    $db->exec('INSERT INTO banned (chat_id, reason, created_at) VALUES (?, ?, ?) ', [$target, 'banned by admin', time()]);
    header('Location: users.php'); exit;
}
if(isset($_GET['unban'])){
    $target = intval($_GET['unban']);
    $db->exec('DELETE FROM banned WHERE chat_id = ?', [$target]);
    header('Location: users.php'); exit;
}

// fetch users
$users = $db->fetch('SELECT id, chat_id, step, partner, created_at FROM users ORDER BY created_at DESC LIMIT 500');
?>
<!doctype html><html lang="fa" dir="rtl"><head><meta charset="utf-8"><title>لیست کاربران</title></head><body>
<h2>مدیریت کاربران</h2><p><a href="index.php">بازگشت</a> | <a href="sendall.php">ارسال همگانی</a></p>
<table border="1" cellpadding="6"><tr><th>ID</th><th>Chat ID</th><th>Step</th><th>Partner</th><th>Created</th><th>Action</th></tr>
<?php foreach($users as $u): ?>
    <tr>
        <td><?=htmlspecialchars($u['id'])?></td>
        <td><?=htmlspecialchars($u['chat_id'])?></td>
        <td><?=htmlspecialchars($u['step'])?></td>
        <td><?=htmlspecialchars($u['partner'])?></td>
        <td><?=htmlspecialchars(date('Y-m-d H:i', $u['created_at']))?></td>
        <td>
            <a href="users.php?ban=<?=$u['chat_id']?>" onclick="return confirm('Ban this user?')">Ban</a>
            <a href="users.php?unban=<?=$u['chat_id']?>" onclick="return confirm('Unban this user?')">Unban</a>
        </td>
    </tr>
<?php endforeach; ?>
</table>
</body></html>
