<?php
session_start();
if(empty($_SESSION['admin'])){ header('Location: index.php'); exit; }
$env_file = dirname(__DIR__) . '/.env';
// load
$env = [];
if(file_exists($env_file)){
    $lines = file($env_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach($lines as $line){
        $line = trim($line);
        if($line === '' || strpos($line,'#')===0) continue;
        if(strpos($line,'=')===false) continue;
        list($k,$v) = explode('=', $line, 2);
        $env[trim($k)] = trim(trim($v), "'\"");
    }
}
$msg='';
if($_SERVER['REQUEST_METHOD'] === 'POST'){
    // update only allowed keys for safety
    $allowed = ['TELEGRAM_PROXY_ENABLED','TELEGRAM_PROXY_URL','ADMIN_USER','ADMIN_PASS','BASE_URL'];
    foreach($allowed as $k){
        if(isset($_POST[$k])) $env[$k] = $_POST[$k];
    }
    // write back to .env preserving other lines roughly
    $out = '';
    foreach($env as $k=>$v){ $out .= $k . '=' . $v . "\n"; }
    file_put_contents($env_file, $out);
    $msg = 'تنظیمات ذخیره شد.';
}
?>
<!doctype html><html lang="fa" dir="rtl"><head><meta charset="utf-8"><title>تنظیمات</title></head><body>
<h2>تنظیمات</h2><p><a href="index.php">بازگشت</a></p>
<?php if($msg) echo '<p style="color:green">'.htmlspecialchars($msg).'</p>'; ?>
<form method="post">
<label>Proxy Enabled: <input name="TELEGRAM_PROXY_ENABLED" value="<?=htmlspecialchars($env['TELEGRAM_PROXY_ENABLED'] ?? 'false')?>"></label><br>
<label>Proxy URL: <input name="TELEGRAM_PROXY_URL" value="<?=htmlspecialchars($env['TELEGRAM_PROXY_URL'] ?? '')?>"></label><br>
<label>Admin User: <input name="ADMIN_USER" value="<?=htmlspecialchars($env['ADMIN_USER'] ?? 'admin')?>"></label><br>
<label>Admin Pass: <input name="ADMIN_PASS" value="<?=htmlspecialchars($env['ADMIN_PASS'] ?? 'change-me')?>"></label><br>
<label>Base URL: <input name="BASE_URL" value="<?=htmlspecialchars($env['BASE_URL'] ?? '')?>"></label><br>
<button>ذخیره</button>
</form>
</body></html>
