<?php
session_start();
require_once __DIR__ . '/../src/bootstrap.php';
// simple auth check
$env_file = dirname(__DIR__) . '/.env';
$env = [];
if(file_exists($env_file)){
    $lines = file($env_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach($lines as $line){
        $line = trim($line);
        if($line === '' || strpos($line,'#')===0) continue;
        if(strpos($line,'=')===false) continue;
        list($k,$v) = explode('=', $line, 2);
        $env[trim($k)] = trim(trim($v), "'\"");
    }
}
$admin_user = $env['ADMIN_USER'] ?? 'admin';
$admin_pass = $env['ADMIN_PASS'] ?? 'change-me';
if(empty($_SESSION['admin'])){ header('Location: index.php'); exit; }

$status = '';
if($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['message'])){
    $text = $_POST['message'];
    // fetch users to send to (simple, send to first 100 for safety)
    $users = $db->fetch('SELECT chat_id FROM users LIMIT 1000');
    $count = 0;
    foreach($users as $u){
        try {
            $tg->sendMessage($u['chat_id'], $text);
            $count++;
        } catch(Exception $e){
            // ignore individual failures
        }
    }
    $status = 'پیام برای ' . $count . ' کاربر ارسال شد.';
}
?>
<!doctype html><html lang="fa" dir="rtl"><head><meta charset="utf-8"><title>ارسال همگانی</title></head><body>
<h2>ارسال همگانی</h2><p><a href="index.php">بازگشت</a></p>
<?php if($status) echo '<p style="color:green">'.htmlspecialchars($status).'</p>'; ?>
<form method="post"><textarea name="message" rows="6" cols="60"></textarea><br><button>ارسال</button></form>
</body></html>
