<?php
session_start();
// keep login behavior in index; show menu when logged in
$env_file = dirname(__DIR__) . '/.env';
$env = [];
if(file_exists($env_file)){
    $lines = file($env_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach($lines as $line){
        $line = trim($line);
        if($line === '' || strpos($line,'#')===0) continue;
        if(strpos($line,'=')===false) continue;
        list($k,$v) = explode('=', $line, 2);
        $env[trim($k)] = trim(trim($v), "'\"");
    }
}
$admin_user = $env['ADMIN_USER'] ?? 'admin';
$admin_pass = $env['ADMIN_PASS'] ?? 'change-me';
if(isset($_GET['logout'])){ session_destroy(); header('Location: index.php'); exit; }
if(empty($_SESSION['admin'])){
    if($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['user']) && isset($_POST['pass'])){
        if($_POST['user'] === $admin_user && $_POST['pass'] === $admin_pass){
            $_SESSION['admin'] = true; header('Location: index.php'); exit;
        } else { $msg = 'خطا در ورود'; }
    }
}
?>
<!doctype html><html lang="fa" dir="rtl"><head><meta charset="utf-8"><title>پنل ادمین</title></head><body>
<?php if(empty($_SESSION['admin'])): ?>
<h3>ورود</h3>
<?php if(!empty($msg)) echo '<p style="color:red">'.htmlspecialchars($msg).'</p>'; ?>
<form method="post"><label>کاربر: <input name="user"></label><br><label>رمز: <input name="pass" type="password"></label><br><button>ورود</button></form>
<?php else: ?>
<h3>داشبورد</h3>
<p><a href="?logout=1">خروج</a></p>
<ul>
    <li><a href="users.php">مدیریت کاربران</a></li>
    <li><a href="sendall.php">ارسال همگانی</a></li>
    <li><a href="settings.php">تنظیمات</a></li>
</ul>
<?php endif; ?>
</body></html>
