<?php
/*
********** مدیریت پروفایل کاربران *********
*/

// شامل کردن config برای اتصال به دیتابیس
if (!isset($GLOBALS['connect'])) {
    include 'config.php';
}

function show_profile($chat_id, $user_id, $message_id = null) {
    $connect = $GLOBALS['connect'];
    
    // اگر متغیرهای global وجود ندارند، تعریفشان کن
    if (!isset($GLOBALS['skill_levels'])) {
        $GLOBALS['skill_levels'] = [
            'beginner' => '🟢 تازه‌کار',
            'intermediate' => '🟡 متوسط', 
            'advanced' => '🔴 حرفه‌ای',
            'pro' => '🟣 نخبه'
        ];
    }
    
    if (!isset($GLOBALS['platforms'])) {
        $GLOBALS['platforms'] = [
            'pc' => '💻 PC',
            'playstation' => '🎮 PlayStation',
            'xbox' => '🎯 Xbox',
            'mobile' => '📱 Mobile',
            'nintendo' => '🎴 Nintendo'
        ];
    }
    
    $skill_levels = $GLOBALS['skill_levels'];
    $platforms = $GLOBALS['platforms'];
    
    $user = mysqli_fetch_assoc(mysqli_query($connect, "SELECT * FROM `users` WHERE `user_id` = '$user_id' LIMIT 1"));
    $profile = get_user_profile($user_id);
    
    if (!$profile) {
        return bot('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "❌ پروفایل شما یافت نشد. لطفا با پشتیبانی تماس بگیرید."
        ]);
    }
    
    $profile_text = "👤 **پروفایل گیمر**\n\n";
    $profile_text .= "📛 نام: {$user['first_name']}\n";
    
    if ($profile['age']) {
        $profile_text .= "🎂 سن: {$profile['age']} سال\n";
    } else {
        $profile_text .= "🎂 سن: تعیین نشده\n";
    }
    
    if ($profile['city']) {
        $profile_text .= "🏙️ شهر: {$profile['city']}\n";
    } else {
        $profile_text .= "🏙️ شهر: تعیین نشده\n";
    }
    
    $profile_text .= "⭐ سطح مهارت: {$skill_levels[$profile['skill_level']]}\n";
    $profile_text .= "📊 امتیاز: {$profile['rating']}/5 ⭐\n";
    $profile_text .= "🎮 تعداد بازی‌ها: {$profile['total_games']}\n";
    
    if ($profile['favorite_games']) {
        $games = json_decode($profile['favorite_games'], true);
        $profile_text .= "\n🎯 بازی‌های مورد علاقه:\n";
        foreach ($games as $game) {
            $profile_text .= "• $game\n";
        }
    } else {
        $profile_text .= "\n🎯 بازی‌های مورد علاقه: تعیین نشده\n";
    }
    
    if ($profile['platforms']) {
        $user_platforms = json_decode($profile['platforms'], true);
        $profile_text .= "\n🎮 پلتفرم‌ها:\n";
        foreach ($user_platforms as $platform) {
            $profile_text .= "• {$platforms[$platform]}\n";
        }
    } else {
        $profile_text .= "\n🎮 پلتفرم‌ها: تعیین نشده\n";
    }
    
    if ($profile['bio']) {
        $profile_text .= "\n📝 درباره من:\n{$profile['bio']}\n";
    } else {
        $profile_text .= "\n📝 درباره من: توضیحاتی ثبت نشده\n";
    }
    
    $keyboard = [
        [['text' => "✏️ ویرایش پروفایل", 'callback_data' => "edit_profile"]],
        [['text' => "⭐ تغییر سطح مهارت", 'callback_data' => "change_skill"]],
        [['text' => "🔙 بازگشت به منوی اصلی", 'callback_data' => "back_to_main"]]
    ];
    
    $params = [
        'chat_id' => $chat_id,
        'text' => $profile_text,
        'parse_mode' => 'Markdown',
        'reply_markup' => json_encode(['inline_keyboard' => $keyboard])
    ];
    
    if ($profile['profile_photo']) {
        $params['photo'] = $profile['profile_photo'];
        $params['caption'] = $profile_text;
        $method = $message_id ? 'editmessagemedia' : 'sendphoto';
        
        if ($method == 'editmessagemedia') {
            $media = [
                'type' => 'photo',
                'media' => $profile['profile_photo'],
                'caption' => $profile_text,
                'parse_mode' => 'Markdown'
            ];
            return bot('editmessagemedia', [
                'chat_id' => $chat_id,
                'message_id' => $message_id,
                'media' => json_encode($media),
                'reply_markup' => json_encode(['inline_keyboard' => $keyboard])
            ]);
        } else {
            return bot('sendphoto', $params);
        }
    } else {
        return $message_id ? 
            bot('editmessagetext', array_merge($params, ['message_id' => $message_id])) :
            bot('sendmessage', $params);
    }
}

function start_profile_creation($chat_id, $user_id) {
    bot('sendmessage', [
        'chat_id' => $chat_id,
        'text' => "🎮 **ساخت پروفایل گیمر**\n\nبرای کامل کردن پروفایل خود، لطفا اطلاعات زیر را وارد کنید:\n\n📛 ابتدا سن خود را وارد کنید:",
        'parse_mode' => 'Markdown',
        'reply_markup' => back_keyboard()
    ]);
    
    mysqli_query($connect, "UPDATE `users` SET `step` = 'profile_age' WHERE `user_id` = '$user_id'");
}

function handle_profile_steps($user_id, $chat_id, $text, $message) {
    global $connect;
    
    $user = mysqli_fetch_assoc(mysqli_query($connect, "SELECT * FROM `users` WHERE `user_id` = '$user_id' LIMIT 1"));
    
    switch ($user['step']) {
        case 'profile_age':
            if (is_numeric($text) && $text >= 10 && $text <= 100) {
                mysqli_query($connect, "UPDATE `profiles` SET `age` = '$text' WHERE `user_id` = '$user_id'");
                mysqli_query($connect, "UPDATE `users` SET `step` = 'profile_city' WHERE `user_id` = '$user_id'");
                
                bot('sendmessage', [
                    'chat_id' => $chat_id,
                    'text' => "✅ سن ذخیره شد!\n\n🏙️ حالا نام شهر خود را وارد کنید:"
                ]);
            } else {
                bot('sendmessage', [
                    'chat_id' => $chat_id,
                    'text' => "❌ سن نامعتبر! لطفا یک عدد بین ۱۰ تا ۱۰۰ وارد کنید:"
                ]);
            }
            break;
            
        case 'profile_city':
            mysqli_query($connect, "UPDATE `profiles` SET `city` = '$text' WHERE `user_id` = '$user_id'");
            mysqli_query($connect, "UPDATE `users` SET `step` = 'profile_bio' WHERE `user_id` = '$user_id'");
            
            bot('sendmessage', [
                'chat_id' => $chat_id,
                'text' => "✅ شهر ذخیره شد!\n\n📝 حالا یک توضیح کوتاه درباره خودت بنویس (اختیاری):\n\nمثال: 'من عاشق بازی‌های استراتژیک هستم و ۳ سال تجربه بازی دارم'",
                'reply_markup' => json_encode([
                    'keyboard' => [
                        [['text' => "رد کردن این مرحله"]],
                        [['text' => "🔙 بازگشت"]]
                    ],
                    'resize_keyboard' => true
                ])
            ]);
            break;
            
        case 'profile_bio':
            if ($text != "رد کردن این مرحله") {
                mysqli_query($connect, "UPDATE `profiles` SET `bio` = '$text' WHERE `user_id` = '$user_id'");
            }
            mysqli_query($connect, "UPDATE `users` SET `step` = 'profile_photo' WHERE `user_id` = '$user_id'");
            
            bot('sendmessage', [
                'chat_id' => $chat_id,
                'text' => "✅ اطلاعات پایه ذخیره شد!\n\n📸 حالا یک عکس برای پروفایل خود ارسال کنید (اختیاری):",
                'reply_markup' => json_encode([
                    'keyboard' => [
                        [['text' => "رد کردن این مرحله"]],
                        [['text' => "🔙 بازگشت"]]
                    ],
                    'resize_keyboard' => true
                ])
            ]);
            break;
            
        case 'profile_photo':
            if (isset($message->photo) && $text != "رد کردن این مرحله") {
                $photo = $message->photo[count($message->photo) - 1]->file_id;
                mysqli_query($connect, "UPDATE `profiles` SET `profile_photo` = '$photo' WHERE `user_id` = '$user_id'");
            }
            
            mysqli_query($connect, "UPDATE `users` SET `step` = 'none' WHERE `user_id` = '$user_id'");
            
            bot('sendmessage', [
                'chat_id' => $chat_id,
                'text' => "🎉 **پروفایل شما با موفقیت ساخته شد!**\n\nحالا می‌توانید از امکانات ربات استفاده کنید:",
                'parse_mode' => 'Markdown',
                'reply_markup' => main_menu_keyboard()
            ]);
            
            // نمایش پروفایل نهایی
            show_profile($chat_id, $user_id);
            break;
    }
}

function edit_profile_section($chat_id, $user_id, $section) {
    global $connect;
    
    $steps = [
        'age' => ['text' => "🎂 سن جدید خود را وارد کنید:", 'step' => 'edit_age'],
        'city' => ['text' => "🏙️ شهر جدید خود را وارد کنید:", 'step' => 'edit_city'],
        'bio' => ['text' => "📝 توضیحات جدید خود را وارد کنید:", 'step' => 'edit_bio'],
        'skill' => ['text' => "⭐ سطح مهارت جدید خود را انتخاب کنید:", 'step' => 'edit_skill']
    ];
    
    if (isset($steps[$section])) {
        bot('sendmessage', [
            'chat_id' => $chat_id,
            'text' => $steps[$section]['text'],
            'reply_markup' => $section == 'skill' ? skill_level_keyboard() : back_keyboard()
        ]);
        
        mysqli_query($connect, "UPDATE `users` SET `step` = '{$steps[$section]['step']}' WHERE `user_id` = '$user_id'");
    }
}

function handle_edit_profile($user_id, $chat_id, $text) {
    global $connect;
    
    $user = mysqli_fetch_assoc(mysqli_query($connect, "SELECT * FROM `users` WHERE `user_id` = '$user_id' LIMIT 1"));
    
    switch ($user['step']) {
        case 'edit_age':
            if (is_numeric($text) && $text >= 10 && $text <= 100) {
                mysqli_query($connect, "UPDATE `profiles` SET `age` = '$text' WHERE `user_id` = '$user_id'");
                bot('sendmessage', ['chat_id' => $chat_id, 'text' => "✅ سن به روز شد!"]);
                show_profile($chat_id, $user_id);
            }
            break;
            
        case 'edit_city':
            mysqli_query($connect, "UPDATE `profiles` SET `city` = '$text' WHERE `user_id` = '$user_id'");
            bot('sendmessage', ['chat_id' => $chat_id, 'text' => "✅ شهر به روز شد!"]);
            show_profile($chat_id, $user_id);
            break;
            
        case 'edit_bio':
            mysqli_query($connect, "UPDATE `profiles` SET `bio` = '$text' WHERE `user_id` = '$user_id'");
            bot('sendmessage', ['chat_id' => $chat_id, 'text' => "✅ توضیحات به روز شد!"]);
            show_profile($chat_id, $user_id);
            break;
    }
    
    mysqli_query($connect, "UPDATE `users` SET `step` = 'none' WHERE `user_id` = '$user_id'");
}

function skill_level_keyboard() {
    global $skill_levels;
    
    $keyboard = [];
    foreach ($skill_levels as $key => $value) {
        $keyboard[] = [['text' => $value, 'callback_data' => "set_skill_$key"]];
    }
    $keyboard[] = [['text' => "🔙 بازگشت", 'callback_data' => "back_to_profile"]];
    
    return json_encode(['inline_keyboard' => $keyboard]);
}

function platforms_keyboard() {
    global $platforms;
    
    $keyboard = [];
    $temp = [];
    foreach ($platforms as $key => $value) {
        $temp[] = ['text' => $value, 'callback_data' => "toggle_platform_$key"];
        if (count($temp) == 2) {
            $keyboard[] = $temp;
            $temp = [];
        }
    }
    if (!empty($temp)) $keyboard[] = $temp;
    
    $keyboard[] = [['text' => "✅ تایید انتخاب", 'callback_data' => "confirm_platforms"]];
    $keyboard[] = [['text' => "🔙 بازگشت", 'callback_data' => "back_to_profile"]];
    
    return json_encode(['inline_keyboard' => $keyboard]);
}
?>