<?php
/*
********** سیستم لابی و پیدا کردن هم‌بازی *********
*/

// شامل کردن config برای اتصال به دیتابیس
if (!isset($GLOBALS['connect'])) {
    include 'config.php';
}

function show_find_teammate_menu($chat_id) {
    $text = "🎮 **پیدا کردن هم‌بازی**\n\n";
    $text .= "چگونه می‌خواهید هم‌بازی پیدا کنید؟\n\n";
    $text .= "🔍 **جستجوی پیشرفته** - فیلترهای دقیق\n";
    $text .= "⚡ **همین الان بازی کنیم** - اتصال فوری\n";
    $text .= "📢 **اعلامیه‌های فعال** - مشاهده درخواست‌ها\n";
    $text .= "👥 **پیشنهادات هوشمند** - پیشنهاد بر اساس پروفایل شما";
    
    $keyboard = [
        [['text' => "🔍 جستجوی پیشرفته"], ['text' => "⚡ همین الان بازی کنیم"]],
        [['text' => "📢 اعلامیه‌های فعال"], ['text' => "👥 پیشنهادات هوشمند"]],
        [['text' => "🔙 بازگشت به منوی اصلی"]]
    ];
    
    bot('sendmessage', [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'Markdown',
        'reply_markup' => json_encode(['keyboard' => $keyboard, 'resize_keyboard' => true])
    ]);
}

function start_create_lobby($chat_id, $user_id) {
    $connect = $GLOBALS['connect'];
    
    // بررسی اینکه کاربر پروفایل کامل دارد
    $profile = get_user_profile($user_id);
    if (!$profile || !$profile['age'] || !$profile['city']) {
        bot('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "❌ برای ایجاد لابی باید پروفایل شما کامل باشد.\n\nلطفا ابتدا پروفایل خود را تکمیل کنید:",
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [['text' => "✏️ تکمیل پروفایل", 'callback_data' => "edit_profile"]],
                    [['text' => "🔙 بازگشت", 'callback_data' => "back_to_main"]]
                ]
            ])
        ]);
        return;
    }
    
    bot('sendmessage', [
        'chat_id' => $chat_id,
        'text' => "🏠 **ایجاد لابی جدید**\n\n🎮 ابتدا نام بازی مورد نظر خود را وارد کنید:\n\nمثال: 'Call of Duty Warzone' یا 'Valorant'",
        'parse_mode' => 'Markdown',
        'reply_markup' => back_keyboard()
    ]);
    
    mysqli_query($connect, "UPDATE `users` SET `step` = 'lobby_game' WHERE `user_id` = '$user_id'");
}

function handle_lobby_creation($user_id, $chat_id, $text) {
    $connect = $GLOBALS['connect'];
    $game_categories = $GLOBALS['game_categories'];
    $platforms = $GLOBALS['platforms'];
    $skill_levels = $GLOBALS['skill_levels'];
    
    $user = mysqli_fetch_assoc(mysqli_query($connect, "SELECT * FROM `users` WHERE `user_id` = '$user_id' LIMIT 1"));
    
    switch ($user['step']) {
        case 'lobby_game':
            if ($text == "🔙 بازگشت") {
                mysqli_query($connect, "UPDATE `users` SET `step` = 'none' WHERE `user_id` = '$user_id'");
                bot('sendmessage', [
                    'chat_id' => $chat_id,
                    'text' => "❌ ایجاد لابی لغو شد.",
                    'reply_markup' => main_menu_keyboard()
                ]);
                break;
            }
            
            // بررسی کن که این پیام واقعاً نام بازی است
            if (!empty($text) && $text != "🔙 بازگشت به منوی اصلی") {
                mysqli_query($connect, "UPDATE `users` SET `step` = 'lobby_category', `step2` = '$text' WHERE `user_id` = '$user_id'");
                
                $keyboard = [];
                foreach ($game_categories as $key => $value) {
                    $keyboard[] = [['text' => $value, 'callback_data' => "lobby_category_$key"]];
                }
                
                bot('sendmessage', [
                    'chat_id' => $chat_id,
                    'text' => "✅ بازی '$text' انتخاب شد!\n\n🎯 حالا دسته‌بندی بازی را انتخاب کنید:",
                    'reply_markup' => json_encode(['inline_keyboard' => $keyboard])
                ]);
            }
            break;
            
        case 'lobby_players':
            if ($text == "🔙 بازگشت") {
                mysqli_query($connect, "UPDATE `users` SET `step` = 'none' WHERE `user_id` = '$user_id'");
                bot('sendmessage', [
                    'chat_id' => $chat_id,
                    'text' => "❌ ایجاد لابی لغو شد.",
                    'reply_markup' => main_menu_keyboard()
                ]);
                break;
            }
            
            if (is_numeric($text) && $text >= 1 && $text <= 10) {
                $steps = explode('|', $user['step2']);
                $steps[] = $text;
                $new_step2 = implode('|', $steps);
                
                mysqli_query($connect, "UPDATE `users` SET `step` = 'lobby_skill', `step2` = '$new_step2' WHERE `user_id` = '$user_id'");
                
                $keyboard = [];
                foreach ($skill_levels as $key => $value) {
                    $keyboard[] = [['text' => $value, 'callback_data' => "lobby_skill_$key"]];
                }
                
                bot('sendmessage', [
                    'chat_id' => $chat_id,
                    'text' => "✅ تعداد بازیکنان ثبت شد!\n\n⭐ سطح مهارت مورد نظر را انتخاب کنید:",
                    'reply_markup' => json_encode(['inline_keyboard' => $keyboard])
                ]);
            } else {
                bot('sendmessage', [
                    'chat_id' => $chat_id,
                    'text' => "❌ تعداد نامعتبر! لطفا عددی بین ۱ تا ۱۰ وارد کنید:"
                ]);
            }
            break;
            
        case 'lobby_description':
            if ($text == "🔙 بازگشت") {
                mysqli_query($connect, "UPDATE `users` SET `step` = 'none' WHERE `user_id` = '$user_id'");
                bot('sendmessage', [
                    'chat_id' => $chat_id,
                    'text' => "❌ ایجاد لابی لغو شد.",
                    'reply_markup' => main_menu_keyboard()
                ]);
                break;
            }
            
            $steps = explode('|', $user['step2']);
            $game_name = $steps[0];
            $category = $steps[1];
            $platform = $steps[2];
            $players_needed = $steps[3];
            $skill_level = $steps[4];
            
            $timestamp = time();
            $expires_at = $timestamp + (2 * 3600); // 2 ساعت اعتبار
            
            // ایجاد لابی
            $insert_query = "INSERT INTO `lobbies` (`creator_id`, `game_name`, `game_category`, `platform`, `skill_level`, `players_needed`, `description`, `created_at`, `expires_at`) 
                            VALUES ('$user_id', '$game_name', '$category', '$platform', '$skill_level', '$players_needed', '$text', '$timestamp', '$expires_at')";
            
            $result = mysqli_query($connect, $insert_query);
            
            if ($result) {
                $lobby_id = mysqli_insert_id($connect);
                
                // اضافه کردن سازنده به لابی
                mysqli_query($connect, "INSERT INTO `lobby_players` (`lobby_id`, `user_id`, `joined_at`) VALUES ('$lobby_id', '$user_id', '$timestamp')");
                
                mysqli_query($connect, "UPDATE `users` SET `step` = 'none', `step2` = NULL WHERE `user_id` = '$user_id'");
                
                // نمایش لابی ایجاد شده
                $lobby = mysqli_fetch_assoc(mysqli_query($connect, "SELECT * FROM `lobbies` WHERE `id` = '$lobby_id' LIMIT 1"));
                show_lobby_details($chat_id, $lobby, true);
                
                bot('sendmessage', [
                    'chat_id' => $chat_id,
                    'text' => "🎉 **لابی شما با موفقیت ایجاد شد!**\n\nبازیکنان دیگر می‌توانند به لابی شما بپیوندند.",
                    'parse_mode' => 'Markdown',
                    'reply_markup' => main_menu_keyboard()
                ]);
            } else {
                bot('sendmessage', [
                    'chat_id' => $chat_id,
                    'text' => "❌ خطا در ایجاد لابی! لطفا دوباره تلاش کنید.",
                    'reply_markup' => main_menu_keyboard()
                ]);
            }
            break;
    }
}

// بقیه توابع بدون تغییر...

function quick_play($user_id, $chat_id) {
    $connect = $GLOBALS['connect'];
    
    // پیدا کردن لابی‌های مناسب بر اساس پروفایل کاربر
    $profile = get_user_profile($user_id);
    
    if (!$profile) {
        return bot('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "❌ برای استفاده از این قابلیت باید پروفایل خود را تکمیل کنید.",
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [['text' => "✏️ تکمیل پروفایل", 'callback_data' => "edit_profile"]]
                ]
            ])
        ]);
    }
    
    $skill_level = $profile['skill_level'];
    
    $suitable_lobbies = mysqli_query($connect, "
        SELECT * FROM `lobbies` 
        WHERE `status` = 'active' 
        AND `skill_level` = '$skill_level'
        ORDER BY `current_players` DESC 
        LIMIT 3
    ");
    
    if (mysqli_num_rows($suitable_lobbies) > 0) {
        $text = "⚡ **پیشنهادات فوری برای شما**\n\n";
        $text .= "بر اساس پروفایل شما، این لابی‌ها مناسب هستند:\n\n";
        
        $keyboard = [];
        while ($lobby = mysqli_fetch_assoc($suitable_lobbies)) {
            $text .= create_lobby_card($lobby) . "\n\n";
            $keyboard[] = [['text' => "✅ پیوستن به {$lobby['game_name']}", 'callback_data' => "join_lobby_{$lobby['id']}"]];
        }
        
        $keyboard[] = [['text' => "🔍 مشاهده همه لابی‌ها", 'callback_data' => "show_all_lobbies"]];
        $keyboard[] = [['text' => "🔙 بازگشت", 'callback_data' => "back_to_main"]];
        
        bot('sendmessage', [
            'chat_id' => $chat_id,
            'text' => $text,
            'parse_mode' => 'Markdown',
            'reply_markup' => json_encode(['inline_keyboard' => $keyboard])
        ]);
    } else {
        bot('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "🔍 هیچ لابی مناسب برای شما یافت نشد.\n\nمی‌توانید خودتان یک لابی ایجاد کنید یا منتظر لابی‌های جدید بمانید.",
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [['text' => "🏠 ایجاد لابی جدید", 'callback_data' => "create_lobby"]],
                    [['text' => "🔄 تلاش مجدد", 'callback_data' => "quick_play"]]
                ]
            ])
        ]);
    }
}
?>