<?php
/*
********** توابع کمکی ربات هم‌بازی *********
*/

// تابع اصلی ربات
function bot($method, $datas = []) {
    $url = 'https://api.telegram.org/bot' . API_KEY . '/' . $method;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $datas);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $result = curl_exec($ch);
    curl_close($ch);
    return json_decode($result);
}

// بررسی ادمین
function is_admin($user_id) {
    global $connect;
    $result = mysqli_query($connect, "SELECT * FROM `admins` WHERE `user_id` = '$user_id' LIMIT 1");
    return mysqli_num_rows($result) > 0;
}

// ایجاد یا بروزرسانی کاربر
function update_user($user_id, $first_name, $username = null) {
    global $connect;
    $timestamp = time();
    
    $user_query = mysqli_query($connect, "SELECT * FROM `users` WHERE `user_id` = '$user_id' LIMIT 1");
    
    if (mysqli_num_rows($user_query) > 0) {
        // بروزرسانی کاربر موجود
        mysqli_query($connect, "UPDATE `users` SET `first_name` = '$first_name', `username` = '$username', `updated_at` = '$timestamp' WHERE `user_id` = '$user_id'");
    } else {
        // ایجاد کاربر جدید
        mysqli_query($connect, "INSERT INTO `users` (`user_id`, `first_name`, `username`, `created_at`, `updated_at`) VALUES ('$user_id', '$first_name', '$username', '$timestamp', '$timestamp')");
        
        // ایجاد پروفایل پیش‌فرض
        mysqli_query($connect, "INSERT INTO `profiles` (`user_id`, `created_at`, `updated_at`) VALUES ('$user_id', '$timestamp', '$timestamp')");
    }
    
    return mysqli_fetch_assoc(mysqli_query($connect, "SELECT * FROM `users` WHERE `user_id` = '$user_id' LIMIT 1"));
}

// دریافت پروفایل کاربر
function get_user_profile($user_id) {
    global $connect;
    $result = mysqli_query($connect, "SELECT * FROM `profiles` WHERE `user_id` = '$user_id' LIMIT 1");
    return mysqli_num_rows($result) > 0 ? mysqli_fetch_assoc($result) : null;
}

// کیبورد منوی اصلی
function main_menu_keyboard() {
    return json_encode([
        'keyboard' => [
            [['text' => "🎮 پیدا کردن هم‌بازی"], ['text' => "🏠 ایجاد لابی"]],
            [['text' => "📢 اعلامیه‌های فعال"], ['text' => "👤 پروفایل من"]],
            [['text' => "👥 تیم‌های من"], ['text' => "⚙️ تنظیمات"]],
            is_admin($GLOBALS['from_id']) ? [['text' => "👑 پنل مدیریت"]] : [],
        ],
        'resize_keyboard' => true,
    ]);
}

// کیبورد بازگشت
function back_keyboard() {
    return json_encode([
        'keyboard' => [
            [['text' => "🔙 بازگشت"]],
        ],
        'resize_keyboard' => true,
    ]);
}

// فرمت‌دهی زمان
function format_time($timestamp) {
    $diff = time() - $timestamp;
    
    if ($diff < 60) return 'همین الان';
    if ($diff < 3600) return floor($diff / 60) . ' دقیقه قبل';
    if ($diff < 86400) return floor($diff / 3600) . ' ساعت قبل';
    if ($diff < 2592000) return floor($diff / 86400) . ' روز قبل';
    
    return date('Y/m/d', $timestamp);
}

// تولید کارت لابی
function create_lobby_card($lobby) {
    global $platforms, $skill_levels;
    
    $creator_profile = get_user_profile($lobby['creator_id']);
    $creator_name = $creator_profile ? $creator_profile['first_name'] : 'ناشناس';
    
    $card = "🎮 **لابی بازی: {$lobby['game_name']}**\n\n";
    $card .= "👤 میزبان: $creator_name\n";
    $card .= "🎯 پلتفرم: {$platforms[$lobby['platform']]}\n";
    $card .= "⭐ سطح مهارت: {$skill_levels[$lobby['skill_level']]}\n";
    $card .= "👥 بازیکنان: {$lobby['current_players']}/{$lobby['players_needed']}\n";
    
    if ($lobby['estimated_time']) {
        $card .= "⏰ زمان تخمینی: {$lobby['estimated_time']} دقیقه\n";
    }
    
    if ($lobby['description']) {
        $card .= "📝 توضیحات: {$lobby['description']}\n";
    }
    
    $card .= "\n🕒 ایجاد شده: " . format_time($lobby['created_at']);
    
    return $card;
}

// بررسی انقضای لابی‌ها
function check_expired_lobbies() {
    global $connect;
    $timestamp = time();
    
    // پیدا کردن لابی‌های منقضی شده
    $expired_lobbies = mysqli_query($connect, "SELECT * FROM `lobbies` WHERE `expires_at` < '$timestamp' AND `status` = 'active'");
    
    while ($lobby = mysqli_fetch_assoc($expired_lobbies)) {
        // آپدیت وضعیت لابی
        mysqli_query($connect, "UPDATE `lobbies` SET `status` = 'cancelled' WHERE `id` = '{$lobby['id']}'");
        
        // اطلاع به شرکت‌کنندگان
        $players = mysqli_query($connect, "SELECT * FROM `lobby_players` WHERE `lobby_id` = '{$lobby['id']}'");
        while ($player = mysqli_fetch_assoc($players)) {
            bot('sendmessage', [
                'chat_id' => $player['user_id'],
                'text' => "⏰ لابی بازی '{$lobby['game_name']}' به دلیل انقضا بسته شد."
            ]);
        }
    }
}

// محاسبه رتبه کاربر
function calculate_user_rating($user_id) {
    global $connect;
    
    // اینجا می‌توانید الگوریتم پیچیده‌تری برای محاسبه رتبه پیاده‌سازی کنید
    $profile = get_user_profile($user_id);
    $total_games = $profile['total_games'];
    $current_rating = $profile['rating'];
    
    // محاسبات ساده برای نمونه
    if ($total_games > 0) {
        return $current_rating;
    }
    
    return 5.00; // رتبه پیش‌فرض
}


?>