<?php
/*
********** ساختار دیتابیس ربات هم‌بازی *********
*/

function create_tables($connect) {
    
    // جدول کاربران
    $users_table = "CREATE TABLE IF NOT EXISTS `users` (
        `id` INT(11) NOT NULL AUTO_INCREMENT,
        `user_id` BIGINT(20) NOT NULL UNIQUE,
        `username` VARCHAR(255) DEFAULT NULL,
        `first_name` VARCHAR(255) NOT NULL,
        `step` VARCHAR(255) DEFAULT 'none',
        `created_at` INT(11) NOT NULL,
        `updated_at` INT(11) NOT NULL,
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
    
    // جدول پروفایل‌ها
    $profiles_table = "CREATE TABLE IF NOT EXISTS `profiles` (
        `id` INT(11) NOT NULL AUTO_INCREMENT,
        `user_id` BIGINT(20) NOT NULL UNIQUE,
        `age` INT(3) DEFAULT NULL,
        `city` VARCHAR(100) DEFAULT NULL,
        `bio` TEXT DEFAULT NULL,
        `profile_photo` VARCHAR(255) DEFAULT NULL,
        `skill_level` ENUM('beginner','intermediate','advanced','pro') DEFAULT 'intermediate',
        `favorite_games` TEXT DEFAULT NULL,
        `platforms` TEXT DEFAULT NULL,
        `is_public` ENUM('true','false') DEFAULT 'true',
        `rating` DECIMAL(3,2) DEFAULT 5.00,
        `total_games` INT(11) DEFAULT 0,
        `created_at` INT(11) NOT NULL,
        `updated_at` INT(11) NOT NULL,
        PRIMARY KEY (`id`),
        FOREIGN KEY (`user_id`) REFERENCES `users`(`user_id`) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
    
    // جدول لابی‌ها
    $lobbies_table = "CREATE TABLE IF NOT EXISTS `lobbies` (
        `id` INT(11) NOT NULL AUTO_INCREMENT,
        `creator_id` BIGINT(20) NOT NULL,
        `game_name` VARCHAR(255) NOT NULL,
        `game_category` VARCHAR(100) NOT NULL,
        `platform` VARCHAR(50) NOT NULL,
        `skill_level` VARCHAR(50) NOT NULL,
        `players_needed` INT(3) NOT NULL,
        `current_players` INT(3) DEFAULT 1,
        `description` TEXT DEFAULT NULL,
        `voice_chat` ENUM('required','optional','none') DEFAULT 'optional',
        `estimated_time` INT(5) DEFAULT NULL,
        `status` ENUM('active','full','cancelled','completed') DEFAULT 'active',
        `created_at` INT(11) NOT NULL,
        `expires_at` INT(11) NOT NULL,
        PRIMARY KEY (`id`),
        FOREIGN KEY (`creator_id`) REFERENCES `users`(`user_id`) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
    
    // جدول شرکت‌کنندگان لابی
    $lobby_players_table = "CREATE TABLE IF NOT EXISTS `lobby_players` (
        `id` INT(11) NOT NULL AUTO_INCREMENT,
        `lobby_id` INT(11) NOT NULL,
        `user_id` BIGINT(20) NOT NULL,
        `joined_at` INT(11) NOT NULL,
        `status` ENUM('joined','left','kicked') DEFAULT 'joined',
        PRIMARY KEY (`id`),
        FOREIGN KEY (`lobby_id`) REFERENCES `lobbies`(`id`) ON DELETE CASCADE,
        FOREIGN KEY (`user_id`) REFERENCES `users`(`user_id`) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
    
    // جدول اعلامیه‌ها
    $announcements_table = "CREATE TABLE IF NOT EXISTS `announcements` (
        `id` INT(11) NOT NULL AUTO_INCREMENT,
        `creator_id` BIGINT(20) NOT NULL,
        `title` VARCHAR(255) NOT NULL,
        `game_name` VARCHAR(255) NOT NULL,
        `players_needed` INT(3) NOT NULL,
        `description` TEXT DEFAULT NULL,
        `platform` VARCHAR(50) NOT NULL,
        `skill_level` VARCHAR(50) NOT NULL,
        `contact_method` VARCHAR(100) NOT NULL,
        `status` ENUM('active','fulfilled','cancelled') DEFAULT 'active',
        `created_at` INT(11) NOT NULL,
        PRIMARY KEY (`id`),
        FOREIGN KEY (`creator_id`) REFERENCES `users`(`user_id`) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
    
    // جدول تیم‌ها
    $teams_table = "CREATE TABLE IF NOT EXISTS `teams` (
        `id` INT(11) NOT NULL AUTO_INCREMENT,
        `name` VARCHAR(255) NOT NULL,
        `creator_id` BIGINT(20) NOT NULL,
        `game` VARCHAR(255) NOT NULL,
        `description` TEXT DEFAULT NULL,
        `logo` VARCHAR(255) DEFAULT NULL,
        `max_members` INT(3) DEFAULT 5,
        `is_public` ENUM('true','false') DEFAULT 'true',
        `created_at` INT(11) NOT NULL,
        PRIMARY KEY (`id`),
        FOREIGN KEY (`creator_id`) REFERENCES `users`(`user_id`) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
    
    // جدول اعضای تیم
    $team_members_table = "CREATE TABLE IF NOT EXISTS `team_members` (
        `id` INT(11) NOT NULL AUTO_INCREMENT,
        `team_id` INT(11) NOT NULL,
        `user_id` BIGINT(20) NOT NULL,
        `role` ENUM('leader','co_leader','member') DEFAULT 'member',
        `joined_at` INT(11) NOT NULL,
        PRIMARY KEY (`id`),
        FOREIGN KEY (`team_id`) REFERENCES `teams`(`id`) ON DELETE CASCADE,
        FOREIGN KEY (`user_id`) REFERENCES `users`(`user_id`) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
    
    // جدول ادمین‌ها
    $admins_table = "CREATE TABLE IF NOT EXISTS `admins` (
        `id` INT(11) NOT NULL AUTO_INCREMENT,
        `user_id` BIGINT(20) NOT NULL UNIQUE,
        `permissions` TEXT DEFAULT NULL,
        `added_by` BIGINT(20) NOT NULL,
        `added_at` INT(11) NOT NULL,
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
    
    // جدول گزارش‌ها
    $reports_table = "CREATE TABLE IF NOT EXISTS `reports` (
        `id` INT(11) NOT NULL AUTO_INCREMENT,
        `reporter_id` BIGINT(20) NOT NULL,
        `reported_user_id` BIGINT(20) NOT NULL,
        `reason` TEXT NOT NULL,
        `lobby_id` INT(11) DEFAULT NULL,
        `status` ENUM('pending','reviewed','resolved') DEFAULT 'pending',
        `created_at` INT(11) NOT NULL,
        PRIMARY KEY (`id`),
        FOREIGN KEY (`reporter_id`) REFERENCES `users`(`user_id`) ON DELETE CASCADE,
        FOREIGN KEY (`reported_user_id`) REFERENCES `users`(`user_id`) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
    
    // اجرای کوئری‌ها
    $tables = [
        $users_table, $profiles_table, $lobbies_table, 
        $lobby_players_table, $announcements_table, $teams_table,
        $team_members_table, $admins_table, $reports_table
    ];
    
    foreach ($tables as $table) {
        if (!$connect->query($table)) {
            return "خطا در ایجاد جدول: " . $connect->error;
        }
    }
    
    // اضافه کردن ادمین اصلی
    $creator = CREATOR;
    $timestamp = time();
    $connect->query("INSERT IGNORE INTO `admins` (`user_id`, `permissions`, `added_by`, `added_at`) VALUES ('$creator', 'all', '$creator', '$timestamp')");
    
    return "تمام جداول با موفقیت ایجاد شدند!";
}
?>