<?php
/*
********** ربات هم‌بازی گیمرها - فایل اصلی *********
*/

// شامل کردن فایل config اول
include 'config.php';

// سپس شامل کردن بقیه فایل‌ها
include 'functions.php';
include 'profile.php';
include 'lobby.php';
include 'admin.php';

// دریافت آپدیت
$input = file_get_contents('php://input');
$update = json_decode($input);
$message = $update->message ?? null;
$callback_query = $update->callback_query ?? null;

// متغیرهای اصلی
$text = '';
$chat_id = '';
$from_id = '';
$first_name = '';
$username = '';
$message_id = '';

if ($message) {
    $message_id = $message->message_id;
    $text = $message->text ?? '';
    $chat_id = $message->chat->id;
    $from_id = $message->from->id;
    $first_name = $message->from->first_name ?? 'کاربر';
    $username = $message->from->username ?? '';
}

if ($callback_query) {
    $data = $callback_query->data;
    $from_id = $callback_query->from->id;
    $message_id = $callback_query->message->message_id;
    $chat_id = $callback_query->message->chat->id;
    $callback_query_id = $callback_query->id;
}

// ایجاد یا بروزرسانی کاربر
if ($from_id) {
    $user = update_user($from_id, $first_name, $username);
}

// ============================ // پردازش Callback Queries // ============================

if ($callback_query) {
    $connect = $GLOBALS['connect'];
    
    // مدیریت پروفایل
    if ($data == "edit_profile") {
        $keyboard = [
            [['text' => "🎂 ویرایش سن", 'callback_data' => "edit_age"]],
            [['text' => "🏙️ ویرایش شهر", 'callback_data' => "edit_city"]],
            [['text' => "📝 ویرایش بیو", 'callback_data' => "edit_bio"]],
            [['text' => "🎯 مدیریت بازی‌ها", 'callback_data' => "manage_games"]],
            [['text' => "⭐ تغییر سطح مهارت", 'callback_data' => "change_skill"]],
            [['text' => "🔙 بازگشت", 'callback_data' => "back_to_profile"]]
        ];
        
        bot('editmessagetext', [
            'chat_id' => $chat_id,
            'message_id' => $message_id,
            'text' => "✏️ **ویرایش پروفایل**\n\nکدام بخش را می‌خواهید ویرایش کنید؟",
            'parse_mode' => 'Markdown',
            'reply_markup' => json_encode(['inline_keyboard' => $keyboard])
        ]);
        exit;
    }
    
    elseif ($data == "edit_age") {
        mysqli_query($connect, "UPDATE `users` SET `step` = 'edit_age' WHERE `user_id` = '$from_id'");
        
        bot('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "🎂 **ویرایش سن**\n\nلطفا سن جدید خود را وارد کنید:",
            'parse_mode' => 'Markdown',
            'reply_markup' => cancel_keyboard()
        ]);
        exit;
    }
    
    elseif ($data == "edit_city") {
        mysqli_query($connect, "UPDATE `users` SET `step` = 'edit_city' WHERE `user_id` = '$from_id'");
        
        bot('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "🏙️ **ویرایش شهر**\n\nلطفا شهر جدید خود را وارد کنید:",
            'parse_mode' => 'Markdown',
            'reply_markup' => cancel_keyboard()
        ]);
        exit;
    }
    
    elseif ($data == "edit_bio") {
        mysqli_query($connect, "UPDATE `users` SET `step` = 'edit_bio' WHERE `user_id` = '$from_id'");
        
        bot('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "📝 **ویرایش توضیحات**\n\nلطفا توضیحات جدید خود را وارد کنید:",
            'parse_mode' => 'Markdown',
            'reply_markup' => cancel_keyboard()
        ]);
        exit;
    }
    
    elseif ($data == "manage_games") {
        mysqli_query($connect, "UPDATE `users` SET `step` = 'add_favorite_game' WHERE `user_id` = '$from_id'");
        
        bot('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "🎯 **مدیریت بازی‌های مورد علاقه**\n\nلطفا نام بازی‌های مورد علاقه خود را وارد کنید (هر خط یک بازی):\n\nمثال:\nValorant\nCall of Duty\nFortnite",
            'parse_mode' => 'Markdown',
            'reply_markup' => cancel_keyboard()
        ]);
        exit;
    }
    
    elseif ($data == "change_skill") {
        bot('editmessagetext', [
            'chat_id' => $chat_id,
            'message_id' => $message_id,
            'text' => "⭐ **تغییر سطح مهارت**\n\nلطفا سطح مهارت خود را انتخاب کنید:",
            'parse_mode' => 'Markdown',
            'reply_markup' => skill_level_keyboard()
        ]);
        exit;
    }
    
    elseif (strpos($data, "set_skill_") === 0) {
        $skill = str_replace("set_skill_", "", $data);
        mysqli_query($connect, "UPDATE `profiles` SET `skill_level` = '$skill' WHERE `user_id` = '$from_id'");
        
        bot('answercallbackquery', [
            'callback_query_id' => $callback_query_id,
            'text' => "✅ سطح مهارت به روز شد!"
        ]);
        
        show_profile($chat_id, $from_id, $message_id);
        exit;
    }
    
    elseif ($data == "back_to_profile") {
        show_profile($chat_id, $from_id, $message_id);
        exit;
    }
    
    // مدیریت لابی
    elseif (strpos($data, "lobby_category_") === 0) {
        $category = str_replace("lobby_category_", "", $data);
        
        $user = mysqli_fetch_assoc(mysqli_query($connect, "SELECT * FROM `users` WHERE `user_id` = '$from_id' LIMIT 1"));
        $game_name = $user['step2'];
        
        mysqli_query($connect, "UPDATE `users` SET `step` = 'lobby_platform', `step2` = '$game_name|$category' WHERE `user_id` = '$from_id'");
        
        $platforms = $GLOBALS['platforms'];
        $keyboard = [];
        foreach ($platforms as $key => $value) {
            $keyboard[] = [['text' => $value, 'callback_data' => "lobby_platform_$key"]];
        }
        $keyboard[] = [['text' => "❌ لغو ایجاد لابی", 'callback_data' => "cancel_lobby"]];
        
        bot('editmessagetext', [
            'chat_id' => $chat_id,
            'message_id' => $message_id,
            'text' => "✅ دسته‌بندی انتخاب شد!\n\n🎮 حالا پلتفرم بازی را انتخاب کنید:",
            'reply_markup' => json_encode(['inline_keyboard' => $keyboard])
        ]);
        exit;
    }
    
    elseif (strpos($data, "lobby_platform_") === 0) {
        $platform = str_replace("lobby_platform_", "", $data);
        
        $user = mysqli_fetch_assoc(mysqli_query($connect, "SELECT * FROM `users` WHERE `user_id` = '$from_id' LIMIT 1"));
        $steps = explode('|', $user['step2']);
        $steps[] = $platform;
        $new_step2 = implode('|', $steps);
        
        mysqli_query($connect, "UPDATE `users` SET `step` = 'lobby_players', `step2` = '$new_step2' WHERE `user_id` = '$from_id'");
        
        bot('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "✅ پلتفرم انتخاب شد!\n\n👥 چند بازیکن دیگر نیاز دارید؟\n\nعدد بین ۱ تا ۱۰ وارد کنید:",
            'reply_markup' => cancel_keyboard()
        ]);
        exit;
    }
    
    elseif (strpos($data, "lobby_skill_") === 0) {
        $skill = str_replace("lobby_skill_", "", $data);
        
        $user = mysqli_fetch_assoc(mysqli_query($connect, "SELECT * FROM `users` WHERE `user_id` = '$from_id' LIMIT 1"));
        $steps = explode('|', $user['step2']);
        $steps[] = $skill;
        $new_step2 = implode('|', $steps);
        
        mysqli_query($connect, "UPDATE `users` SET `step` = 'lobby_description', `step2` = '$new_step2' WHERE `user_id` = '$from_id'");
        
        bot('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "✅ سطح مهارت انتخاب شد!\n\n📝 حالا یک توضیح برای لابی خود بنویسید (اختیاری):\n\nمثال: 'به دنبال بازیکنان حرفه‌ای برای تیم رنک هستم'",
            'reply_markup' => cancel_keyboard()
        ]);
        exit;
    }
    
    elseif ($data == "cancel_lobby") {
        mysqli_query($connect, "UPDATE `users` SET `step` = 'none', `step2` = NULL WHERE `user_id` = '$from_id'");
        
        bot('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "❌ ایجاد لابی لغو شد.\n\n🔙 به منوی اصلی بازگشتی.",
            'reply_markup' => main_menu_keyboard()
        ]);
        exit;
    }
    
    elseif ($data == "create_lobby") {
        start_create_lobby($chat_id, $from_id);
        exit;
    }
    
    elseif (strpos($data, "join_lobby_") === 0) {
        $lobby_id = str_replace("join_lobby_", "", $data);
        $result = join_lobby($from_id, $lobby_id);
        
        bot('answercallbackquery', [
            'callback_query_id' => $callback_query_id,
            'text' => $result
        ]);
        
        if (strpos($result, "✅") !== false) {
            $lobby = mysqli_fetch_assoc(mysqli_query($connect, "SELECT * FROM `lobbies` WHERE `id` = '$lobby_id' LIMIT 1"));
            show_lobby_details($chat_id, $lobby);
        }
        exit;
    }
    
    elseif ($data == "quick_play") {
        quick_play($from_id, $chat_id);
        exit;
    }
    
    elseif ($data == "show_all_lobbies") {
        show_active_lobbies($chat_id);
        exit;
    }
    
    elseif ($data == "back_to_find_menu") {
        show_find_teammate_menu($chat_id);
        exit;
    }
    
    elseif ($data == "back_to_main") {
        mysqli_query($connect, "UPDATE `users` SET `step` = 'none' WHERE `user_id` = '$from_id'");
        
        bot('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "🔙 به منوی اصلی بازگشتی.",
            'reply_markup' => main_menu_keyboard()
        ]);
        exit;
    }
    
    // پاسخ به callback query
    bot('answercallbackquery', [
        'callback_query_id' => $callback_query_id,
        'text' => "✅ انجام شد"
    ]);
    exit;
}

// ============================ // پردازش مراحل کاربر // ============================

if ($message && $from_id) {
    $connect = $GLOBALS['connect'];
    $user = mysqli_fetch_assoc(mysqli_query($connect, "SELECT * FROM `users` WHERE `user_id` = '$from_id' LIMIT 1"));
    
    // اگر کاربر در مرحله‌ای است، آن را پردازش کن
    if ($user && $user['step'] != 'none') {
        
        // بررسی دکمه لغو
        if ($text == "❌ لغو عملیات") {
            mysqli_query($connect, "UPDATE `users` SET `step` = 'none', `step2` = NULL WHERE `user_id` = '$from_id'");
            
            bot('sendmessage', [
                'chat_id' => $chat_id,
                'text' => "❌ عملیات لغو شد.\n\n🔙 به منوی اصلی بازگشتی.",
                'reply_markup' => main_menu_keyboard()
            ]);
            exit;
        }
        
        // پردازش مراحل ویرایش پروفایل
        if ($user['step'] == 'edit_age') {
            if (is_numeric($text) && $text >= 10 && $text <= 100) {
                mysqli_query($connect, "UPDATE `profiles` SET `age` = '$text' WHERE `user_id` = '$from_id'");
                mysqli_query($connect, "UPDATE `users` SET `step` = 'none' WHERE `user_id` = '$from_id'");
                
                bot('sendmessage', [
                    'chat_id' => $chat_id,
                    'text' => "✅ سن شما با موفقیت به $text سال به روز شد!",
                    'reply_markup' => main_menu_keyboard()
                ]);
                
                show_profile($chat_id, $from_id);
            } else {
                bot('sendmessage', [
                    'chat_id' => $chat_id,
                    'text' => "❌ سن نامعتبر! لطفا عددی بین ۱۰ تا ۱۰۰ وارد کنید:",
                    'reply_markup' => cancel_keyboard()
                ]);
            }
            exit;
        }
        
        elseif ($user['step'] == 'edit_city') {
            mysqli_query($connect, "UPDATE `profiles` SET `city` = '$text' WHERE `user_id` = '$from_id'");
            mysqli_query($connect, "UPDATE `users` SET `step` = 'none' WHERE `user_id` = '$from_id'");
            
            bot('sendmessage', [
                'chat_id' => $chat_id,
                'text' => "✅ شهر شما با موفقیت به $text به روز شد!",
                'reply_markup' => main_menu_keyboard()
            ]);
            
            show_profile($chat_id, $from_id);
            exit;
        }
        
        elseif ($user['step'] == 'edit_bio') {
            mysqli_query($connect, "UPDATE `profiles` SET `bio` = '$text' WHERE `user_id` = '$from_id'");
            mysqli_query($connect, "UPDATE `users` SET `step` = 'none' WHERE `user_id` = '$from_id'");
            
            bot('sendmessage', [
                'chat_id' => $chat_id,
                'text' => "✅ توضیحات شما با موفقیت به روز شد!",
                'reply_markup' => main_menu_keyboard()
            ]);
            
            show_profile($chat_id, $from_id);
            exit;
        }
        
        elseif ($user['step'] == 'add_favorite_game') {
            if (!empty($text)) {
                $games = explode("\n", $text);
                $cleaned_games = [];
                foreach ($games as $game) {
                    $cleaned_game = trim($game);
                    if (!empty($cleaned_game)) {
                        $cleaned_games[] = $cleaned_game;
                    }
                }
                
                if (!empty($cleaned_games)) {
                    $games_json = json_encode($cleaned_games);
                    mysqli_query($connect, "UPDATE `profiles` SET `favorite_games` = '$games_json' WHERE `user_id` = '$from_id'");
                    mysqli_query($connect, "UPDATE `users` SET `step` = 'none' WHERE `user_id` = '$from_id'");
                    
                    $games_list = implode("\n• ", $cleaned_games);
                    bot('sendmessage', [
                        'chat_id' => $chat_id,
                        'text' => "✅ بازی‌های مورد علاقه شما با موفقیت ذخیره شد!\n\n• $games_list",
                        'reply_markup' => main_menu_keyboard()
                    ]);
                    
                    show_profile($chat_id, $from_id);
                } else {
                    bot('sendmessage', [
                        'chat_id' => $chat_id,
                        'text' => "❌ هیچ بازی معتبری وارد نشده است. لطفا دوباره تلاش کنید:",
                        'reply_markup' => cancel_keyboard()
                    ]);
                }
            } else {
                bot('sendmessage', [
                    'chat_id' => $chat_id,
                    'text' => "❌ لطفا نام بازی‌ها را وارد کنید:",
                    'reply_markup' => cancel_keyboard()
                ]);
            }
            exit;
        }
        
        // پردازش مراحل ایجاد پروفایل
        if (in_array($user['step'], ['profile_age', 'profile_city', 'profile_bio', 'profile_photo'])) {
            handle_profile_steps($from_id, $chat_id, $text, $message);
            exit;
        }
        
        // پردازش مراحل ایجاد لابی
        if (in_array($user['step'], ['lobby_game', 'lobby_players', 'lobby_description'])) {
            handle_lobby_creation($from_id, $chat_id, $text);
            exit;
        }
    }
}

// ============================ // پردازش دستورات اصلی // ============================

// دستور start
if ($text == "/start") {
    $connect = $GLOBALS['connect'];
    
    // اگر کاربر در مرحله‌ای گیر کرده، آن را لغو کن
    $user = mysqli_fetch_assoc(mysqli_query($connect, "SELECT * FROM `users` WHERE `user_id` = '$from_id' LIMIT 1"));
    if ($user && $user['step'] != 'none') {
        mysqli_query($connect, "UPDATE `users` SET `step` = 'none', `step2` = NULL WHERE `user_id` = '$from_id'");
    }
    
    $profile = get_user_profile($from_id);
    
    if (!$profile || !$profile['age']) {
        start_profile_creation($chat_id, $from_id);
    } else {
        bot('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "🎮 **به ربات هم‌بازی خوش آمدید!**\n\nامروز می‌خواهید چطور هم‌بازی پیدا کنید؟",
            'parse_mode' => 'Markdown',
            'reply_markup' => main_menu_keyboard()
        ]);
    }
    exit;
}

// منوی اصلی
if ($text == "🔙 بازگشت به منوی اصلی" || $text == "🔙 بازگشت") {
    $connect = $GLOBALS['connect'];
    mysqli_query($connect, "UPDATE `users` SET `step` = 'none' WHERE `user_id` = '$from_id'");
    
    bot('sendmessage', [
        'chat_id' => $chat_id,
        'text' => "🔙 به منوی اصلی بازگشتی.",
        'reply_markup' => main_menu_keyboard()
    ]);
    exit;
}

// لیست منوهای اصلی
$main_menu_items = [
    "🎮 پیدا کردن هم‌بازی",
    "🏠 ایجاد لابی", 
    "📢 اعلامیه‌های فعال",
    "👤 پروفایل من",
    "👥 تیم‌های من",
    "⚙️ تنظیمات",
    "👑 پنل مدیریت"
];

if (in_array($text, $main_menu_items)) {
    
    if ($text == "🎮 پیدا کردن هم‌بازی") {
        show_find_teammate_menu($chat_id);
        exit;
    }
    
    elseif ($text == "🏠 ایجاد لابی") {
        start_create_lobby($chat_id, $from_id);
        exit;
    }
    
    elseif ($text == "📢 اعلامیه‌های فعال") {
        show_active_lobbies($chat_id);
        exit;
    }
    
    elseif ($text == "👤 پروفایل من") {
        show_profile($chat_id, $from_id);
        exit;
    }
    
    elseif ($text == "👥 تیم‌های من") {
        bot('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "👥 **سیستم تیم‌ها**\n\nاین بخش به زودی اضافه خواهد شد...",
            'parse_mode' => 'Markdown',
            'reply_markup' => main_menu_keyboard()
        ]);
        exit;
    }
    
    elseif ($text == "⚙️ تنظیمات") {
        bot('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "⚙️ **تنظیمات کاربری**\n\nاین بخش به زودی اضافه خواهد شد...",
            'parse_mode' => 'Markdown',
            'reply_markup' => main_menu_keyboard()
        ]);
        exit;
    }
    
    elseif ($text == "👑 پنل مدیریت" && is_admin($from_id)) {
        show_admin_panel($chat_id);
        exit;
    }
}

// منوی پیدا کردن هم‌بازی
$find_menu_items = [
    "🔍 جستجوی پیشرفته",
    "⚡ همین الان بازی کنیم", 
    "📢 اعلامیه‌های فعال",
    "👥 پیشنهادات هوشمند"
];

if (in_array($text, $find_menu_items)) {
    
    if ($text == "🔍 جستجوی پیشرفته") {
        bot('sendmessage', [
            'chat_id' => $chat_id,
            'text' => "🔍 **جستجوی پیشرفته**\n\nاین قابلیت به زودی اضافه خواهد شد...\n\nمی‌توانید از جستجوی فوری استفاده کنید:",
            'parse_mode' => 'Markdown',
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [['text' => "⚡ جستجوی فوری", 'callback_data' => "quick_play"]],
                    [['text' => "🔙 بازگشت", 'callback_data' => "back_to_find_menu"]]
                ]
            ])
        ]);
        exit;
    }
    
    elseif ($text == "⚡ همین الان بازی کنیم") {
        quick_play($from_id, $chat_id);
        exit;
    }
    
    elseif ($text == "📢 اعلامیه‌های فعال") {
        show_active_lobbies($chat_id);
        exit;
    }
    
    elseif ($text == "👥 پیشنهادات هوشمند") {
        quick_play($from_id, $chat_id);
        exit;
    }
}

// پنل مدیریت
if (is_admin($from_id)) {
    $admin_menu_items = [
        "📊 آمار دقیق",
        "👥 مدیریت کاربران",
        "🎮 مدیریت لابی‌ها", 
        "🚫 مدیریت گزارش‌ها",
        "📢 ارسال اطلاعیه",
        "⚙️ تنظیمات سیستم"
    ];
    
    if (in_array($text, $admin_menu_items)) {
        
        if ($text == "📊 آمار دقیق") {
            show_detailed_stats($chat_id);
            exit;
        }
        
        elseif ($text == "👥 مدیریت کاربران") {
            manage_users_panel($chat_id);
            exit;
        }
        
        elseif ($text == "🎮 مدیریت لابی‌ها") {
            manage_lobbies_panel($chat_id);
            exit;
        }
        
        elseif ($text == "🚫 مدیریت گزارش‌ها") {
            manage_reports_panel($chat_id);
            exit;
        }
        
        elseif ($text == "📢 ارسال اطلاعیه") {
            send_broadcast_message($chat_id, $from_id);
            exit;
        }
        
        elseif ($text == "⚙️ تنظیمات سیستم") {
            system_settings_panel($chat_id);
            exit;
        }
    }
}

// ============================ // پیام‌های متفرقه // ============================

if ($text) {
    bot('sendmessage', [
        'chat_id' => $chat_id,
        'text' => "🎮 از منوی زیر انتخاب کنید:",
        'reply_markup' => main_menu_keyboard()
    ]);
}

// بروزرسانی زمان فعالیت کاربر
if ($message && $from_id) {
    $timestamp = time();
    $connect = $GLOBALS['connect'];
    mysqli_query($connect, "UPDATE `users` SET `updated_at` = '$timestamp' WHERE `user_id` = '$from_id'");
}

echo "OK";
?>