<?php
/*
********** پنل مدیریت ربات هم‌بازی *********
*/

function show_admin_panel($chat_id) {
    global $connect;
    
    // آمار کلی
    $total_users = mysqli_fetch_assoc(mysqli_query($connect, "SELECT COUNT(*) as count FROM `users`"))['count'];
    $total_lobbies = mysqli_fetch_assoc(mysqli_query($connect, "SELECT COUNT(*) as count FROM `lobbies`"))['count'];
    $active_lobbies = mysqli_fetch_assoc(mysqli_query($connect, "SELECT COUNT(*) as count FROM `lobbies` WHERE `status` = 'active'"))['count'];
    $total_teams = mysqli_fetch_assoc(mysqli_query($connect, "SELECT COUNT(*) as count FROM `teams`"))['count'];
    $pending_reports = mysqli_fetch_assoc(mysqli_query($connect, "SELECT COUNT(*) as count FROM `reports` WHERE `status` = 'pending'"))['count'];
    
    $admin_text = "👑 **پنل مدیریت - آمار کلی**\n\n";
    $admin_text .= "👥 کاربران کل: $total_users\n";
    $admin_text .= "🎮 لابی‌های کل: $total_lobbies\n";
    $admin_text .= "🟢 لابی‌های فعال: $active_lobbies\n";
    $admin_text .= "👥 تیم‌ها: $total_teams\n";
    $admin_text .= "🚫 گزارش‌های pending: $pending_reports\n";
    $admin_text .= "\n🕒 آخرین بروزرسانی: " . date('H:i - Y/m/d');
    
    $keyboard = [
        [['text' => "📊 آمار دقیق"], ['text' => "👥 مدیریت کاربران"]],
        [['text' => "🎮 مدیریت لابی‌ها"], ['text' => "🚫 مدیریت گزارش‌ها"]],
        [['text' => "📢 ارسال اطلاعیه"], ['text' => "⚙️ تنظیمات سیستم"]],
        [['text' => "🔙 بازگشت به منوی اصلی"]]
    ];
    
    bot('sendmessage', [
        'chat_id' => $chat_id,
        'text' => $admin_text,
        'parse_mode' => 'Markdown',
        'reply_markup' => json_encode(['keyboard' => $keyboard, 'resize_keyboard' => true])
    ]);
}

function show_detailed_stats($chat_id) {
    global $connect;
    
    // آمار کاربران
    $users_today = mysqli_fetch_assoc(mysqli_query($connect, "
        SELECT COUNT(*) as count FROM `users` 
        WHERE `created_at` > UNIX_TIMESTAMP(CURDATE())
    "))['count'];
    
    $users_week = mysqli_fetch_assoc(mysqli_query($connect, "
        SELECT COUNT(*) as count FROM `users` 
        WHERE `created_at` > UNIX_TIMESTAMP(DATE_SUB(NOW(), INTERVAL 7 DAY))
    "))['count'];
    
    // آمار لابی‌ها
    $lobbies_today = mysqli_fetch_assoc(mysqli_query($connect, "
        SELECT COUNT(*) as count FROM `lobbies` 
        WHERE `created_at` > UNIX_TIMESTAMP(CURDATE())
    "))['count'];
    
    $completed_lobbies = mysqli_fetch_assoc(mysqli_query($connect, "
        SELECT COUNT(*) as count FROM `lobbies` 
        WHERE `status` = 'full'
    "))['count'];
    
    // محبوب‌ترین بازی‌ها
    $popular_games = mysqli_query($connect, "
        SELECT `game_name`, COUNT(*) as count 
        FROM `lobbies` 
        GROUP BY `game_name` 
        ORDER BY count DESC 
        LIMIT 5
    ");
    
    $stats_text = "📊 **آمار دقیق سیستم**\n\n";
    $stats_text .= "👥 **آمار کاربران:**\n";
    $stats_text .= "• امروز: $users_today کاربر جدید\n";
    $stats_text .= "• ۷ روز گذشته: $users_week کاربر جدید\n\n";
    
    $stats_text .= "🎮 **آمار لابی‌ها:**\n";
    $stats_text .= "• امروز: $lobbies_today لابی جدید\n";
    $stats_text .= "• تکمیل شده: $completed_lobbies لابی\n\n";
    
    $stats_text .= "🏆 **محبوب‌ترین بازی‌ها:**\n";
    while ($game = mysqli_fetch_assoc($popular_games)) {
        $stats_text .= "• {$game['game_name']} ({$game['count']} لابی)\n";
    }
    
    // آمار پلتفرم‌ها
    $platform_stats = mysqli_query($connect, "
        SELECT `platform`, COUNT(*) as count 
        FROM `lobbies` 
        GROUP BY `platform` 
        ORDER BY count DESC
    ");
    
    $stats_text .= "\n🎯 **توزیع پلتفرم‌ها:**\n";
    while ($platform = mysqli_fetch_assoc($platform_stats)) {
        $stats_text .= "• {$platform['platform']}: {$platform['count']}\n";
    }
    
    bot('sendmessage', [
        'chat_id' => $chat_id,
        'text' => $stats_text,
        'parse_mode' => 'Markdown',
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "🔄 بروزرسانی آمار", 'callback_data' => "refresh_stats"]],
                [['text' => "🔙 بازگشت", 'callback_data' => "back_to_admin"]]
            ]
        ])
    ]);
}

function manage_users_panel($chat_id, $page = 1) {
    global $connect;
    
    $limit = 10;
    $offset = ($page - 1) * $limit;
    
    $users = mysqli_query($connect, "
        SELECT u.*, p.rating, p.total_games 
        FROM `users` u 
        LEFT JOIN `profiles` p ON u.user_id = p.user_id 
        ORDER BY u.created_at DESC 
        LIMIT $limit OFFSET $offset
    ");
    
    $text = "👥 **مدیریت کاربران** - صفحه $page\n\n";
    
    if (mysqli_num_rows($users) > 0) {
        while ($user = mysqli_fetch_assoc($users)) {
            $text .= "👤 {$user['first_name']}\n";
            $text .= "🆔 {$user['user_id']}\n";
            $text .= "⭐ امتیاز: {$user['rating']} | 🎮 بازی‌ها: {$user['total_games']}\n";
            $text .= "📅 عضو شده: " . date('Y/m/d', $user['created_at']) . "\n";
            $text .= "➖➖➖➖➖➖➖➖➖➖\n\n";
        }
        
        $total_users = mysqli_fetch_assoc(mysqli_query($connect, "SELECT COUNT(*) as count FROM `users`"))['count'];
        $total_pages = ceil($total_users / $limit);
        
        $keyboard = [];
        if ($page > 1) {
            $keyboard[] = [['text' => "⬅️ صفحه قبلی", 'callback_data' => "users_page_" . ($page - 1)]];
        }
        if ($page < $total_pages) {
            $keyboard[] = [['text' => "صفحه بعدی ➡️", 'callback_data' => "users_page_" . ($page + 1)]];
        }
        
        $keyboard[] = [['text' => "🔍 جستجوی کاربر", 'callback_data' => "search_user"]];
        $keyboard[] = [['text' => "🔙 بازگشت", 'callback_data' => "back_to_admin"]];
        
    } else {
        $text = "📭 کاربری یافت نشد.";
        $keyboard = [[['text' => "🔙 بازگشت", 'callback_data' => "back_to_admin"]]];
    }
    
    bot('sendmessage', [
        'chat_id' => $chat_id,
        'text' => $text,
        'reply_markup' => json_encode(['inline_keyboard' => $keyboard])
    ]);
}

function manage_lobbies_panel($chat_id, $page = 1) {
    global $connect;
    
    $limit = 5;
    $offset = ($page - 1) * $limit;
    
    $lobbies = mysqli_query($connect, "
        SELECT l.*, u.first_name 
        FROM `lobbies` l 
        LEFT JOIN `users` u ON l.creator_id = u.user_id 
        ORDER BY l.created_at DESC 
        LIMIT $limit OFFSET $offset
    ");
    
    $text = "🎮 **مدیریت لابی‌ها** - صفحه $page\n\n";
    
    if (mysqli_num_rows($lobbies) > 0) {
        while ($lobby = mysqli_fetch_assoc($lobbies)) {
            $status_icons = [
                'active' => '🟢',
                'full' => '🔵', 
                'cancelled' => '🔴',
                'completed' => '🟣'
            ];
            
            $text .= "{$status_icons[$lobby['status']]} {$lobby['game_name']}\n";
            $text .= "👤 میزبان: {$lobby['first_name']}\n";
            $text .= "👥 بازیکنان: {$lobby['current_players']}/{$lobby['players_needed']}\n";
            $text .= "🕒 ایجاد: " . date('H:i', $lobby['created_at']) . "\n";
            $text .= "📊 وضعیت: {$lobby['status']}\n";
            
            $keyboard_row = [];
            if ($lobby['status'] == 'active') {
                $keyboard_row[] = ['text' => "❌ بستن لابی", 'callback_data' => "admin_close_lobby_{$lobby['id']}"];
            }
            $keyboard_row[] = ['text' => "👥 مشاهده اعضا", 'callback_data' => "admin_view_players_{$lobby['id']}"];
            $keyboard[] = $keyboard_row;
            
            $text .= "➖➖➖➖➖➖➖➖➖➖\n\n";
        }
        
        $total_lobbies = mysqli_fetch_assoc(mysqli_query($connect, "SELECT COUNT(*) as count FROM `lobbies`"))['count'];
        $total_pages = ceil($total_lobbies / $limit);
        
        $nav_keyboard = [];
        if ($page > 1) {
            $nav_keyboard[] = [['text' => "⬅️ صفحه قبلی", 'callback_data' => "lobbies_admin_page_" . ($page - 1)]];
        }
        if ($page < $total_pages) {
            $nav_keyboard[] = [['text' => "صفحه بعدی ➡️", 'callback_data' => "lobbies_admin_page_" . ($page + 1)]];
        }
        $nav_keyboard[] = [['text' => "🔙 بازگشت", 'callback_data' => "back_to_admin"]];
        
        $keyboard = array_merge($keyboard, $nav_keyboard);
        
    } else {
        $text = "📭 لابی‌ای یافت نشد.";
        $keyboard = [[['text' => "🔙 بازگشت", 'callback_data' => "back_to_admin"]]];
    }
    
    bot('sendmessage', [
        'chat_id' => $chat_id,
        'text' => $text,
        'reply_markup' => json_encode(['inline_keyboard' => $keyboard])
    ]);
}

function manage_reports_panel($chat_id, $page = 1) {
    global $connect;
    
    $limit = 5;
    $offset = ($page - 1) * $limit;
    
    $reports = mysqli_query($connect, "
        SELECT r.*, u1.first_name as reporter_name, u2.first_name as reported_name 
        FROM `reports` r 
        LEFT JOIN `users` u1 ON r.reporter_id = u1.user_id 
        LEFT JOIN `users` u2 ON r.reported_user_id = u2.user_id 
        WHERE r.status = 'pending' 
        ORDER BY r.created_at DESC 
        LIMIT $limit OFFSET $offset
    ");
    
    $text = "🚫 **گزارش‌های pending** - صفحه $page\n\n";
    
    if (mysqli_num_rows($reports) > 0) {
        while ($report = mysqli_fetch_assoc($reports)) {
            $text .= "👤 گزارش‌دهنده: {$report['reporter_name']}\n";
            $text .= "🚫 گزارش شده: {$report['reported_name']}\n";
            $text .= "📝 دلیل: {$report['reason']}\n";
            $text .= "🕒 زمان: " . date('H:i', $report['created_at']) . "\n\n";
            
            $keyboard[] = [
                ['text' => "✅ تایید گزارش", 'callback_data' => "approve_report_{$report['id']}"],
                ['text' => "❌ رد گزارش", 'callback_data' => "reject_report_{$report['id']}"],
                ['text' => "👁️ مشاهده جزئیات", 'callback_data' => "view_report_{$report['id']}"]
            ];
            
            $text .= "➖➖➖➖➖➖➖➖➖➖\n\n";
        }
        
        $total_reports = mysqli_fetch_assoc(mysqli_query($connect, "SELECT COUNT(*) as count FROM `reports` WHERE status = 'pending'"))['count'];
        $total_pages = ceil($total_reports / $limit);
        
        $nav_keyboard = [];
        if ($page > 1) {
            $nav_keyboard[] = [['text' => "⬅️ صفحه قبلی", 'callback_data' => "reports_page_" . ($page - 1)]];
        }
        if ($page < $total_pages) {
            $nav_keyboard[] = [['text' => "صفحه بعدی ➡️", 'callback_data' => "reports_page_" . ($page + 1)]];
        }
        $nav_keyboard[] = [['text' => "🔙 بازگشت", 'callback_data' => "back_to_admin"]];
        
        $keyboard = array_merge($keyboard, $nav_keyboard);
        
    } else {
        $text = "✅ هیچ گزارش pending‌ای وجود ندارد.";
        $keyboard = [[['text' => "🔙 بازگشت", 'callback_data' => "back_to_admin"]]];
    }
    
    bot('sendmessage', [
        'chat_id' => $chat_id,
        'text' => $text,
        'reply_markup' => json_encode(['inline_keyboard' => $keyboard])
    ]);
}

function send_broadcast_message($chat_id, $user_id) {
    global $connect;
    
    bot('sendmessage', [
        'chat_id' => $chat_id,
        'text' => "📢 **ارسال اطلاعیه همگانی**\n\nلطفا پیام خود را ارسال کنید:\n\n⚠️ توجه: این پیام برای تمام کاربران ارسال خواهد شد.",
        'parse_mode' => 'Markdown',
        'reply_markup' => back_keyboard()
    ]);
    
    mysqli_query($connect, "UPDATE `users` SET `step` = 'admin_broadcast' WHERE `user_id` = '$user_id'");
}

function handle_admin_broadcast($user_id, $chat_id, $text) {
    global $connect;
    
    if ($text == "🔙 بازگشت") {
        mysqli_query($connect, "UPDATE `users` SET `step` = 'none' WHERE `user_id` = '$user_id'");
        return show_admin_panel($chat_id);
    }
    
    // تأیید ارسال اطلاعیه
    $confirm_text = "📢 **پیش‌نمایش اطلاعیه**\n\n";
    $confirm_text .= $text . "\n\n";
    $confirm_text .= "آیا از ارسال این اطلاعیه اطمینان دارید؟";
    
    bot('sendmessage', [
        'chat_id' => $chat_id,
        'text' => $confirm_text,
        'parse_mode' => 'Markdown',
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "✅ بله، ارسال کن", 'callback_data' => "confirm_broadcast"]],
                [['text' => "❌ خیر، ویرایش کن", 'callback_data' => "edit_broadcast"]]
            ]
        ])
    ]);
    
    mysqli_query($connect, "UPDATE `users` SET `step` = 'admin_broadcast_confirm', `step2` = '$text' WHERE `user_id` = '$user_id'");
}

function process_broadcast($user_id, $chat_id, $message_text) {
    global $connect;
    
    $users = mysqli_query($connect, "SELECT `user_id` FROM `users`");
    $total_users = mysqli_num_rows($users);
    $success_count = 0;
    $fail_count = 0;
    
    bot('sendmessage', [
        'chat_id' => $chat_id,
        'text' => "🔄 در حال ارسال اطلاعیه به $total_users کاربر..."
    ]);
    
    $final_message = "📢 **اطلاعیه از مدیریت**\n\n" . $message_text;
    
    while ($user = mysqli_fetch_assoc($users)) {
        $result = bot('sendmessage', [
            'chat_id' => $user['user_id'],
            'text' => $final_message,
            'parse_mode' => 'Markdown'
        ]);
        
        if ($result->ok) {
            $success_count++;
        } else {
            $fail_count++;
        }
        
        // تأخیر برای جلوگیری از محدودیت تلگرام
        usleep(100000); // 0.1 ثانیه
    }
    
    $result_text = "✅ **ارسال اطلاعیه تکمیل شد**\n\n";
    $result_text .= "👥 کاربران کل: $total_users\n";
    $result_text .= "✅ ارسال موفق: $success_count\n";
    $result_text .= "❌ ارسال ناموفق: $fail_count";
    
    bot('sendmessage', [
        'chat_id' => $chat_id,
        'text' => $result_text,
        'parse_mode' => 'Markdown'
    ]);
    
    mysqli_query($connect, "UPDATE `users` SET `step` = 'none', `step2` = NULL WHERE `user_id` = '$user_id'");
}

function system_settings_panel($chat_id) {
    $text = "⚙️ **تنظیمات سیستم**\n\n";
    $text .= "در این بخش می‌توانید تنظیمات کلی ربات را مدیریت کنید.\n\n";
    $text .= "🔧 امکانات در حال توسعه...";
    
    bot('sendmessage', [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'Markdown',
        'reply_markup' => json_encode([
            'inline_keyboard' => [
                [['text' => "🔄 بروزرسانی ربات", 'callback_data' => "system_update"]],
                [['text' => "🧹 پاکسازی داده‌ها", 'callback_data' => "system_cleanup"]],
                [['text' => "🔙 بازگشت", 'callback_data' => "back_to_admin"]]
            ]
        ])
    ]);
}
?>